

/////////////////////////////////////////////////////////
// globals...
////////////////////////////////////////////////////////////

float4x4	g_worldViewProjMatrix;
float4x4	g_worldMatrix;
float4x4	g_worldViewMatrix;
float4x4	g_viewMatrix;
float4x4	g_viewProjMatrix;
float4x4	g_projMatrix;

float4		g_light_direction;
float4 		g_camera_position;

////////////////////////////////////////////////////////////////////

struct VS_INPUT
{
	float4 position		: POSITION;
	float4 normal		: NORMAL;
};

struct VS_OUTPUT_HIGH
{
	float4 position		: POSITION;
	float4 colour		: COLOR;
};

VS_OUTPUT_HIGH vs_shadow_projector( VS_INPUT input )
{
	VS_OUTPUT_HIGH output = (VS_OUTPUT_HIGH) 0;

	float4 trans_point = mul(input.position, g_worldViewMatrix);
	output.position = mul(input.position, g_worldMatrix);

	float3 trans_normal = normalize(mul(input.normal, (float3x3)g_worldMatrix));
	float3 vCamera = normalize(output.position-g_camera_position);
	if (dot( trans_normal, -vCamera ) < 0.0)
		trans_normal *= -1.0;


	float3 trans_normal = mul(input.normal, (float3x3)g_viewMatrix);
	float3 light_dir = mul(g_light_direction, (float3x3)g_viewMatrix);


	output.colour = float4(1,1,1,1);
	if (dot(trans_normal, light_dir) < 0.0f) 
	{
		trans_point += g_light_direction * ( 1.0 - trans_point.z ) / light_dir.z;
		trans_point = mul(trans_point, g_projMatrix);
	}
	else
	{
		output.position = mul(output.position, g_viewProjMatrix);
	}
		

	return output;
}

////////////////////////////////////////////////////////////

technique tech_shadow_projector_11_00
{
	pass P0
	{
        VertexShader = compile vs_1_1 vs_shadow_projector();
    }
}